<?php
/**
 * @package WordPress
 * @subpackage Twitter WP Theme
 */

get_header();
?>

	<div id="main" class="left">

	<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

					<div <?php post_class() ?> id="post-<?php the_ID(); ?>">
						<h1 class="postTitle"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
						<div class="postInfo">
							<?php _e('By','twitterwp'); ?><span class="postAuthor"><?php the_author() ?></span> |
							<span class="postDate"> <?php the_time('F jS, Y') ?></span> | 
							<span class="postCategory"><?php the_category(', ','multiple') ?></span> |
							<span class="postComment"><?php comments_popup_link(__('no responses','twitterwp','one response','twitterwp','% responses','twitterwp')); ?></span>
							</div>
						
						<?php the_content(__('Read the rest of this entry &raquo;','twitterwp')); ?>
						<?php wp_link_pages(); ?>
					
					</div>
				

	<?php comments_template(); ?>

	<?php endwhile; else: ?>

		<p><?php _e('Sorry, no posts matched your criteria.','twitterwp'); ?></p>

	<?php endif; ?>

	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
