<?php
/**
 * @package WordPress
 * @subpackage Twitter WP Theme
 */

get_header(); ?>

	<div id="main" class="left">

	<?php if (have_posts()) : ?>
		<h1 class="postTitle"><?php _e('Search Results','twitterwp'); ?></h1>
		<br />
		<?php while (have_posts()) : the_post(); ?>
		<div class="post searchresult">
			<h1 class="posttitle searchTitle"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
						<div class="postInfo">
							<?php _e('By','twitterwp'); ?><span class="postAuthor"><?php the_author() ?></span> |
							<span class="postDate"> <?php the_time('F jS, Y') ?></span> | 
							<span class="postCategory"><?php the_category(', ','multiple') ?></span> |
							<span class="postComment"><?php comments_popup_link(__('no responses','twitterwp','one response','twitterwp','% responses','twitterwp')); ?></span>
							</div>


			</div>

		<?php endwhile; ?>

				<div class="navigation">
						<span class="right"><?php next_posts_link(__('&laquo; Previous Entries','twitterwp')); ?></span>
						<span class="left"><?php previous_posts_link(__('Next Entries &raquo;','twitterwp')); ?></span>
 						<div class="clear"></div>
					</div>

	<?php else : ?>

					<div <?php post_class() ?>>
						<h2 class="center"><?php _e('Not Found','twitterwp'); ?></h2>
						<p class="center"><?php _e('Sorry, but you are looking for something that isnt here.','twitterwp'); ?></p>
					</div>

	<?php endif; ?>

	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
