<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section
 *
 * @package WordPress
 * @subpackage Starkers
 * @since Starkers HTML5 3.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    
    

<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title><?php
 
    global $page, $paged;
 
    wp_title( '|', true, 'right' );
 
    bloginfo( 'name' );
 
    $site_description = get_bloginfo( 'description', 'display' );
    if ( $site_description && ( is_home() || is_front_page() ) )
        echo " | $site_description";
 
    if ( $paged >= 2 || $page >= 2 )
        echo ' | ' . sprintf( __( 'Page %s', 'starkers' ), max( $paged, $page ) );
 
    ?></title>

    <!-- <link rel="profile" href="http://gmpg.org/xfn/11" /> -->

    
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
 
<script src="<?php bloginfo('template_directory'); ?>/js/modernizr-1.6.min.js"></script>
 

    
<!-- Copy to the head section of your webpage -->
    
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/SliderJavaScript/jquery.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/SliderJavaScript/mhrotator.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory'); ?>/SliderJavaScript/initrotatorToken01.js"></script>
    
<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/SliderJavaScript/mhrotator.css" type="text/css" />
<!-- End of head section codes -->
    
    
<!-- Crunchify's Scroll to Top Script --> 
<script>            
	jQuery(document).ready(function() {
		var offset = 220;
		var duration = 500;
		jQuery(window).scroll(function() {
			if (jQuery(this).scrollTop() > offset) {
				jQuery('.crunchify-top').fadeIn(duration);
			} else {
				jQuery('.crunchify-top').fadeOut(duration);
			}
		});
 
		jQuery('.crunchify-top').click(function(event) {
			event.preventDefault();
			jQuery('html, body').animate({scrollTop: 0}, duration);
			return false;
		})
	});
</script>
    <!--end of go top button-->
    
    
    <?php
    /* We add some JavaScript to pages with the comment form
     * to support sites with threaded comments (when in use).
     */
    if ( is_singular() && get_option( 'thread_comments' ) )
        wp_enqueue_script( 'comment-reply' );
 
    /* Always have wp_head() just before the closing </head>
     * tag of your theme, or you will break many plugins, which
     * generally use this hook to add elements to <head> such
     * as styles, scripts, and meta tags.
     */
    wp_head();
?>


 




</head>
 
    
    
<body <?php body_class(); ?>>


    <a name="top"></a>


<div id="DateSection">
	
    
	<div id="DateBar">
        
        <div id="DateName">
       
            
<?php /*include ('jdf.php');*/

$day_number = jdate('j');
$month_number = jdate('n');
$year_number = jdate('o');
$day_name = jdate('l');


            
echo "امروز $day_name ، $day_number / $month_number / $year_number";
?>
            
            
        </div>
        
        <!-- <div id="ChangeLanguge">English</div> -->

    </div>
    
</div>


<div id="master">



<div id="header">

	<div id="logo">
	<img src="<?php bloginfo('template_directory'); ?>/images/logo04.png">
	</div>
	
	<div id="pageTitle">شـرکت عـمرانی پـیـون</div>
	
</div>

<div id="menu"> 
    
        <?php /* Our navigation menu.  If one isn't filled out, wp_nav_menu falls back to the 'starkers_menu' function which can be found in functions.php.  The menu assiged to the primary position is the one used.  If none is assigned, the menu with the lowest ID is used.  */ ?>
        <?php wp_nav_menu( array( 'container' => 'nav', 'fallback_cb' => 'starkers_menu', 'theme_location' => 'primary' ) ); ?>
		
		<!-- we can use this part of code insted abowe block:-->

		<!-- <php wp_page_menu('show_home=1&sort_column=post_date'); ?>  -->
        
		
		</div>
