<?php
/**
 * @package WordPress
 * @subpackage Default_Theme
 */

// Do not delete these lines
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('لطفا" از این صفحه کپی برداری نکنید!');

	if ( post_password_required() ) { ?>
		<p class="nocomments">برای مشاهده مطلب لطفا کلمه عبور را وارد کنید.</p>
	<?php
		return;
	}
?>

<!-- You can start editing here. -->

<div id="comments">

<?php if ( have_comments() ) : ?>
	<div class="box" id="met">
    <h3 class="reply"><?php comments_number('بدون نظر', 'یک نظر', '% نظر' );?> در '<?php the_title(); ?>'</h3>
    <div class="meta-comment"><?php comments_rss_link(__('اشتراک در خوراک نظرات RSS')); ?></div>
    </div>
    
	<ol class="commentlist box">
	<?php wp_list_comments('type=comment&callback=mytheme_comment'); ?>
	</ol>

	<div class="navigation">
		<div class="alignleft cp"><?php previous_comments_link() ?></div>
		<div class="alignright cp"><?php next_comments_link() ?></div>
	</div>
 <?php else : // this is displayed if there are no comments so far ?>

	<?php if ('open' == $post->comment_status) : ?>
		<!-- If comments are open, but there are no comments. -->

	 <?php else : // comments are closed ?>
		<!-- If comments are closed. -->
		<p class="nocomments">نظرات بسته شده.</p>
		</div>
	<?php endif; ?>
<?php endif; ?>


<?php if ('open' == $post->comment_status) : ?>

<div id="respond" class="box">

<h3><?php comment_form_title( 'ارسال نظر به', 'اظهار نظر به %s' ); ?></h3>

<div class="cancel-comment-reply">
	<small><?php cancel_comment_reply_link(); ?></small>
</div>

<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
<p>برای ارسال نظر باید <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php echo urlencode(get_permalink()); ?>">وارد</a> پروفایل خود شوید.</p>
<?php else : ?>

<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

<?php if ( $user_ID ) : ?>

<p>خوش آمدید <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="خروج">خروج &raquo;</a></p>

<?php else : ?>

<div><label for="author"><small>نام و نام خانوادگی <?php if ($req) echo "(الزامی)"; ?></small></label><br /><input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" size="22" tabindex="1" <?php if ($req) echo "aria-required='true'"; ?> />
</div>

<div><label for="email"><small>پست الکترونیکی <?php if ($req) echo "(الزامی)"; ?></small></label><br /><input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="22" tabindex="2" <?php if ($req) echo "aria-required='true'"; ?> />
</div>

<div><label for="url"><small>سایت/وبلاگ</small></label><br /><input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="22" tabindex="3" />
</div>

<?php endif; ?>

<div><small><strong>XHTML:</strong>:<br /><code><?php echo allowed_tags(); ?></code></small></div>

<p><label for="comments"><small>نظرات</small></label><br /><textarea name="comment" id="comment" cols="50" rows="6" tabindex="4"></textarea></p>

<p><input name="submit" type="submit" id="submit" tabindex="5" value="ارسال نظر" class="box" />
<?php comment_id_fields(); ?>
</p>
<?php do_action('comment_form', $post->ID); ?>

</form>
</div>
<?php endif; // If registration required and not logged in ?>
</div>

<?php endif; // if you delete this the sky will fall on your head ?>
